#!/bin/sh
# ---------------------------------------------------
# Start Script for LAS
#
# Environment Variable Prerequisites
#
#   ORACLE_HOME     Oracle database installation home.
# ---------------------------------------------------

# Get required environment variables
if [ ! -r "$ORACLE_HOME"/jdbc/lib/ojdbc5.jar ]; then
  echo "Cannot find $ORACLE_HOME/lib/ojdbc5.jar"
  echo "This file is needed to run this program"
  exit 1
fi

if [ ! -r "$ORACLE_HOME"/jdk/bin/java ]; then
  echo "Cannot find $ORACLE_HOME/jdk/bin/java"
  echo "This file is needed to run this program"
  exit 1
fi


JARS=.:$ORACLE_HOME/jdbc/lib/ojdbc5.jar:$ORACLE_HOME/lib/xmlparserv2.jar

# Set the locations for required jar files as appropriate.

#JARS="$JARS":$ORACLE_HOME/md/jlib/sdoapi.jar
#JARS="$JARS":$ORACLE_HOME/md/jlib/sdoutl.jar
#JARS="$JARS":$ORACLE_HOME/md/jlib/sdotype.jar

JAVA_PARAMS="-Xms256M -Xmx256M"
EDITOR_CLASS=LASOracleLoader
PROG_ARGS="-computerName stadb31.us.oracle.com -portNumber 29720 -databaseName view3m -driver thin -schemaName scott -password tiger -lasfilenames $ORACLE_HOME/md/demo/PointCloud/examples/LAS/LASFileNames.txt " 
# To see what the program parameters are, please uncomment below line and comment above line. 
#PROG_ARGS=" -h "
exec $ORACLE_HOME/jdk/bin/java $JAVA_PARAMS -classpath "$JARS" $EDITOR_CLASS $PROG_ARGS
